<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitasModel;

    public function __construct()
    {
        $this->aktivitasModel = new AktivitasModel();
    }

    // ===============================
    // FRONTEND (READ ONLY)
    // ===============================
    public function frontend()
    {
        return view('frontend/aktivitas', [
            'aktivitas' => $this->aktivitasModel
                ->orderBy('tanggal', 'DESC')
                ->findAll()
        ]);
    }

    // ===============================
    // READ + SEARCH + PAGINATION (Backend)
    // ===============================
    public function index()
    {
        $keyword = $this->request->getGet('keyword');
        $tanggal = $this->request->getGet('tanggal');
        $sort    = $this->request->getGet('sort') ?? 'id';
        $order   = $this->request->getGet('order') ?? 'desc';

        $query = $this->aktivitasModel;

        // 🔍 SEARCH
        if ($keyword) {
            $query = $query->like('nama_aktivitas', $keyword);
        }

        // 🎛 FILTER (tanggal)
        if ($tanggal) {
            $query = $query->where('tanggal', $tanggal);
        }

        // ↕ SORTING + 📄 PAGINATION
        $data['aktivitas'] = $query->orderBy($sort, $order)
            ->paginate(10);

        $data['pager'] = $this->aktivitasModel->pager;

        return view('aktivitas/index', $data);
    }


    // ===============================
    // CREATE - FORM
    // ===============================
    public function create()
    {
        return view('aktivitas/create');
    }

    // ===============================
    // STORE
    // ===============================
    public function store()
    {
        $mediaType = $this->request->getPost('media_type');
        $media = null;

        // 📸 UPLOAD FILE
        if ($mediaType === 'upload') {
            $file = $this->request->getFile('media_file');

            if ($file && $file->isValid()) {
                $media = $file->getRandomName();
                $file->move('uploads/aktivitas', $media);
            }
        }

        // 🔗 LINK
        if ($mediaType === 'link') {
            $media = $this->request->getPost('media_link');
        }

        $this->aktivitasModel->save([
            'tanggal'        => $this->request->getPost('tanggal'),
            'jam'            => $this->request->getPost('jam'),
            'nama_aktivitas' => $this->request->getPost('nama_aktivitas'),
            'media'          => $media,
            'media_type'     => $mediaType,
        ]);

        return redirect()->to('/auth/aktivitas')
            ->with('success', 'Aktivitas berhasil ditambahkan');
    }


    // ===============================
    // EDIT - FORM
    // ===============================
    public function edit($id)
    {
        $data['aktivitas'] = $this->aktivitasModel->find($id);
        return view('aktivitas/edit', $data);
    }

    // ===============================
    // UPDATE
    // ===============================
    public function update($id)
    {
        $data = [
            'tanggal'        => $this->request->getPost('tanggal'),
            'jam'            => $this->request->getPost('jam'),
            'nama_aktivitas' => $this->request->getPost('nama_aktivitas'),
        ];

        $file = $this->request->getFile('media');

        // 🔁 GANTI MEDIA JIKA ADA
        if ($file && $file->isValid() && !$file->hasMoved()) {
            $aktivitas = $this->aktivitasModel->find($id);

            if ($aktivitas['media'] && file_exists('uploads/aktivitas/' . $aktivitas['media'])) {
                unlink('uploads/aktivitas/' . $aktivitas['media']);
            }

            $namaFile = $file->getRandomName();
            $file->move('uploads/aktivitas', $namaFile);
            $data['media'] = $namaFile;
        }

        $this->aktivitasModel->update($id, $data);

        return redirect()->to('/auth/aktivitas')
            ->with('success', 'Aktivitas berhasil diperbarui');
    }

    // ===============================
    // DELETE
    // ===============================
    public function delete($id)
    {
        $aktivitas = $this->aktivitasModel->find($id);

        if ($aktivitas['media'] && file_exists('uploads/aktivitas/' . $aktivitas['media'])) {
            unlink('uploads/aktivitas/' . $aktivitas['media']);
        }

        $this->aktivitasModel->delete($id);

        return redirect()->to('/auth/aktivitas')
            ->with('success', 'Aktivitas berhasil dihapus');
    }
}
